/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics.texture;

import icyllis.modernui.graphics.GLWrapper;

public class Texture2D
implements AutoCloseable {
    private int mId = -1;
    private int mTarget;

    public Texture2D() {
        this(3553);
    }

    public Texture2D(int target) {
        this.mTarget = target;
    }

    public int getId() {
        if (this.mId == -1) {
            this.mId = GLWrapper.glGenTextures();
        }
        return this.mId;
    }

    public void bind() {
        GLWrapper.bindTexture(this.mTarget, this.getId());
    }

    public void setTarget(int target) {
        if (this.mId == -1) {
            this.mTarget = target;
        }
    }

    public int getTarget() {
        return this.mTarget;
    }

    public void init(int internalFormat, int width, int height, int mipmapLevel) {
        this.bind();
        GLWrapper.glTexParameteri((int)this.mTarget, (int)33084, (int)0);
        GLWrapper.glTexParameteri((int)this.mTarget, (int)33085, (int)mipmapLevel);
        GLWrapper.glTexParameteri((int)this.mTarget, (int)33082, (int)0);
        GLWrapper.glTexParameteri((int)this.mTarget, (int)33083, (int)mipmapLevel);
        GLWrapper.glTexParameterf((int)this.mTarget, (int)34049, (float)0.0f);
        for (int level = 0; level <= mipmapLevel; ++level) {
            GLWrapper.glTexImage2D((int)this.mTarget, (int)level, (int)internalFormat, (int)(width >> level), (int)(height >> level), (int)0, (int)6403, (int)5121, (long)0L);
        }
    }

    public void setStorage(int internalFormat, int width, int height, int mipmapLevel) {
        this.bind();
        GLWrapper.glTexParameteri((int)this.mTarget, (int)33084, (int)0);
        GLWrapper.glTexParameteri((int)this.mTarget, (int)33085, (int)mipmapLevel);
        GLWrapper.glTexParameteri((int)this.mTarget, (int)33082, (int)0);
        GLWrapper.glTexParameteri((int)this.mTarget, (int)33083, (int)mipmapLevel);
        GLWrapper.glTexParameterf((int)this.mTarget, (int)34049, (float)0.0f);
        GLWrapper.glTexStorage2D((int)this.mTarget, (int)mipmapLevel, (int)internalFormat, (int)width, (int)height);
    }

    public void upload(int level, int x, int y, int width, int height, int rowLength, int skipRows, int skipPixels, int alignment, int format, int type, long pixels) {
        this.bind();
        GLWrapper.glPixelStorei((int)3314, (int)rowLength);
        GLWrapper.glPixelStorei((int)3315, (int)skipRows);
        GLWrapper.glPixelStorei((int)3316, (int)skipPixels);
        GLWrapper.glPixelStorei((int)3317, (int)alignment);
        GLWrapper.glTexSubImage2D((int)this.mTarget, (int)level, (int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (long)pixels);
    }

    public void setWrapMode(int wrapS) {
        GLWrapper.glTexParameteri((int)this.mTarget, (int)10242, (int)wrapS);
    }

    public void setWrapMode(int wrapS, int wrapT) {
        GLWrapper.glTexParameteri((int)this.mTarget, (int)10242, (int)wrapS);
        GLWrapper.glTexParameteri((int)this.mTarget, (int)10243, (int)wrapT);
    }

    public void setWrapMode(int wrapS, int wrapT, int wrapR) {
        GLWrapper.glTexParameteri((int)this.mTarget, (int)10242, (int)wrapS);
        GLWrapper.glTexParameteri((int)this.mTarget, (int)10243, (int)wrapT);
        GLWrapper.glTexParameteri((int)this.mTarget, (int)32882, (int)wrapR);
    }

    public void setFilter(boolean linear, boolean mipmap) {
        if (linear) {
            if (mipmap) {
                GLWrapper.glTexParameteri((int)this.mTarget, (int)10241, (int)9987);
            } else {
                GLWrapper.glTexParameteri((int)this.mTarget, (int)10241, (int)9729);
            }
            GLWrapper.glTexParameteri((int)this.mTarget, (int)10240, (int)9729);
        } else {
            if (mipmap) {
                GLWrapper.glTexParameteri((int)this.mTarget, (int)10241, (int)9986);
            } else {
                GLWrapper.glTexParameteri((int)this.mTarget, (int)10241, (int)9728);
            }
            GLWrapper.glTexParameteri((int)this.mTarget, (int)10240, (int)9728);
        }
    }

    public void setFilter(int minFilter, int magFilter) {
        GLWrapper.glTexParameteri((int)this.mTarget, (int)10241, (int)minFilter);
        GLWrapper.glTexParameteri((int)this.mTarget, (int)10240, (int)magFilter);
    }

    public void generateMipmap() {
        GLWrapper.glGenerateMipmap((int)this.mTarget);
    }

    public void destroy() {
        if (this.mId != -1) {
            GLWrapper.deleteTexture(this.mTarget, this.mId);
            this.mId = -1;
        }
    }

    @Override
    public void close() throws Exception {
        this.destroy();
    }
}

